<!DOCTYPE html>
<html>
<head>
	<title>My books</title>
	<style>
		table{
			border-collapse: collapse;
			border: 1px solid #333;
			width: fixed;
			break-word: word;
		}
		tr{
			border: 1px solid #333;
			background-color: #eee;
		}
		td{
			border: 1px solid #333; 
		}
		thead tr th{
			background-color: blue;
		}
		tr:nth-of-type(even){
			background-color: grey;
		}
		tr:nth-of-type(odd){
			background-color: lightblue;
		}
		tr:hover(){
			background-color: yellow;
		}
	</style>
</head>
<body>

	<h1>Collections (<?php echo $books->num_rows(); ?> books)</h1>
	<?php $this->load->helper('url'); ?>
	<?php $this->load->library('session'); ?>
	<form action="<?php echo site_url('book/index'); ?>" method="get">
	<label for="searchtext">Search keywords: </label>
	<input type="text" name="searchtext" value="" placeholder="author/title/isbn/publisher">
	<button type="submit">Search </button> 
	</form>

	<form action="<?php echo site_url('book/add_book'); ?>" method="post">
	<button type="submit">ADD BOOK</button>
	</form>

	<form action="<?php echo site_url('login/dologout'); ?>">
	<button type="submit">Logout</button>
	</form>
		<table>
		<thead>
			<tr>
				<th>ISBN</th>
				<th>Title</th>
				<th>Author</th>
				<th>Publisher</th>
				<th>Year</th>
				<th>Cover</th>
				<th>Action</th>
			</tr>
		</thead>
		<tbody>
			<?php foreach($books->result() as $row): ?>
				<tr>
					<td><?php echo $row->isbn; ?></td>
					<td><?php echo $row->title; ?></td>
					<td><?php echo $row->author; ?></td>
					<td><?php echo $row->publisher; ?></td>
					<td><?php echo $row->year; ?></td>
					<td><img src = "<?php echo $row->imagesmall; ?>"></td>
					<td>Detail / Delete</td>
				</tr>
			<?php endforeach; ?>		
		</tbody>
	</table>
	
</body>
</html>