<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Lapeling | DLHKubar</title>

    <!-- Styles -->
    <link href="/css/font-awesome.min.css" rel='stylesheet' type='text/css'>
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link href="/css/jquery.dataTables.css" rel="stylesheet">
    <link href="/css/dataTables.bootstrap.css" rel="stylesheet">
    <link href="/css/selectize.css" rel="stylesheet">
    <link href="/css/paper.css" rel="stylesheet">
    <link href="/css/selectize.bootstrap3.css" rel="stylesheet">
</head>
<body>
    <div id="app">
        <nav class="navbar navbar-default navbar-static-top">
            <div class="container">
                <div class="navbar-header">

                    <!-- Collapsed Hamburger -->
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#app-navbar-collapse">
                        <span class="sr-only">Toggle Navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>

                    <!-- Branding Image -->
                    <a class="navbar-brand" href="<?php echo e(url('/')); ?>">
                        Lapeling | DLHKubar
                    </a>
                </div>

                <div class="collapse navbar-collapse" id="app-navbar-collapse">
                    <!-- Left Side Of Navbar -->
                    <ul class="nav navbar-nav">
                      <?php if(Auth::check()): ?>
                        <li><a href="<?php echo e(url('/home')); ?>">Dashboard</a></li>
                      <?php endif; ?>

                      <?php if (app('laratrust')->hasRole('admin')) : ?>
                        <li><a href="<?php echo e(route('perusahaan.index')); ?>">Data Perusahaan</a></li>
                        <li><a href="<?php echo e(route('laporan.index')); ?>">Laporan</a></li>
                        <li><a href="<?php echo e(action('PerusahaanController@kontak')); ?>">Contact Dev</a></li>
                      <?php endif; // app('laratrust')->hasRole ?>

                      <?php if (app('laratrust')->hasRole('member')) : ?>
                        <li><a href="<?php echo e(action('HomeController@edit')); ?>">Data Perusahaan</a></li>
                      <?php endif; // app('laratrust')->hasRole ?>
                      
                    </ul>

                    <!-- Right Side Of Navbar -->
                    <ul class="nav navbar-nav navbar-right">
                        <!-- Authentication Links -->
                        <?php if(Auth::guest()): ?>
                            <li><a href="<?php echo e(url('login')); ?>">Login</a></li>
                            <li><a href="<?php echo e(url('/register')); ?>">Daftar</a></li>
                        <?php else: ?>
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
                                    <?php echo e(Auth::user()->name); ?> <span class="caret"></span>
                                </a>

                                <ul class="dropdown-menu" role="menu">
                                    <li>
                                        <a href="<?php echo e(route('logout')); ?>"
                                            onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                            Logout
                                        </a>

                                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                            <?php echo e(csrf_field()); ?>

                                        </form>
                                    </li>
                                </ul>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>
        <?php echo $__env->make('layouts._flash', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
        
    </div>
    <footer class="footer hidden-print">
        <div class="container">
            <span class="text-muted">Aplikasi dalam tahap pengembangan v.1.0 <a href="#"><strong>TEAM IT</strong></a></span>
        </div>
    </footer>
    <!-- Scripts -->
    <script src="/js/jquery-3.2.1.min.js"></script>
    <script src="/js/bootstrap.min.js"></script>
    <script src="/js/jquery.dataTables.min.js"></script>
    <script src="/js/dataTables.bootstrap.min.js"></script>
    <script src="/js/custom.js"></script>
    <script src="/js/selectize.min.js"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
