/**
 * Appendo Plugin for jQuery v1.1 (modification for yii)
 * Creates interface to create duplicate clones of last table row (usually for forms)
 * (c) 2008 Kelly Hallman. Free software released under MIT License.
 * See http://deepliquid.com/content/Appendo.html for more info
 */
jQuery.fn.appendo = function(opt)
{
	this.each(function() { jQuery.appendo.init(this,opt); });
	return this;
};
jQuery.appendo = function() {
	var myself = this;
	this.opt = { };
	this.init = function(obj,opt) {
		var options = jQuery.extend({
				labelAdd:		'Add Row',
				labelDel:		'Remove',
				allowDelete:	true,
				copyHandlers:	false,
				focusFirst:		true,
				onAdd:			function() { return true; },
				onDel:		function() { return true; },
				maxRows:		0,
				wrapClass:		'appendoButtons',
				wrapStyle:		{ padding: '.4em .2em .5em' },
				buttonStyle:	{ marginRight: '.5em'},
				subSelect:		'tr:last'
			},
			myself.opt,
			opt
		);
		var $cpy = jQuery(obj).find(options.subSelect).clone(options.copyHandlers);
		var rows = 1;		
		var $add_btn = new_button(options.labelAdd).click(clicked_add),$del_btn = new_button(options.labelDel).click(clicked_del).hide();
		function add_row()
		{
			var $dup = $cpy.clone(options.copyHandlers);
			$dup.appendTo(obj);
			update_buttons(1);
			if (typeof(options.onAdd) == "function") options.onAdd($dup);
			if (!!options.focusFirst) $dup.find('input:first').focus();
		};
		function del_row(){
			var $row = jQuery(obj).find(options.subSelect);
			if ((typeof(options.onDel) != "function") || options.onDel($row))
			{
				$row.remove();
				update_buttons(-1);
			}
		};
		function update_buttons(rowdelta){
			rows = rows + (rowdelta || 0);
			$add_btn.attr('disabled',(!options.maxRows || (rows < options.maxRows))?false:true);
			(options.allowDelete && (rows > 1))? $del_btn.show().css({'display':'inline'}): $del_btn.hide();
		};
		function new_button(label){return jQuery('<button />').css(options.buttonStyle).html(label);};
		function nothing(e){e.stopPropagation();e.preventDefault();return false;};
		function clicked_add(e){if (!options.maxRows || (rows < options.maxRows)) add_row();return nothing(e);};
		function clicked_del(e){
			if (rows > 1) del_row(); 
			return nothing(e);
		};
	
		// Add the buttons after the table instance
		jQuery('<div />')
			.addClass(options.wrapClass)
			.css(options.wrapStyle)
			.append( $add_btn, $del_btn )
			.insertAfter(obj);

		// Update the buttons
		update_buttons();

	};
	return this;
}();